﻿//////////////////////////////////////////////
// DataAllocator.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkInputs
{
	class GamepadDevice ;
	class KeyboardDevice ;
	class MouseDevice ;
	class System ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkInputs
{
	class DataAllocator
	{
		public :

			// Constructor, destructor
			DataAllocator (System* system) noexcept ;
			virtual ~DataAllocator () ;

			// Allocations
			virtual nkMemory::UniquePtr<GamepadDevice> allocateGamepadDevice () const = 0 ;
			virtual nkMemory::UniquePtr<KeyboardDevice> allocateKeyboardDevice () const = 0 ;
			virtual nkMemory::UniquePtr<MouseDevice> allocateMouseDevice () const = 0 ;

		protected :

			System* _system ;
	} ;
}